package com.team5.aLife.Client;

public class GetDeviceReply extends AbstractReply{

	enum DeviceType {
		DEVICE,
		POWERSWITCH,
		THERMOSTAT;
	}
	
	Device device;
	PowerSwitchDevice powerSwitch;
	Thermostat thermostat;
	
	DeviceType mode;
	
	public GetDeviceReply(){
		//  Do nothing.  Needed for JSON
	}
	
	public GetDeviceReply(Device device){
		this.device = device;
		mode = DeviceType.DEVICE;
	}
	
	public GetDeviceReply(PowerSwitchDevice powerSwitch)
	{
		this.powerSwitch = powerSwitch;
		mode = DeviceType.POWERSWITCH;
	}
	
	public GetDeviceReply(Thermostat thermostat){
		this.thermostat = thermostat;
		mode = DeviceType.THERMOSTAT;
	}
	
	@Override
	public int getReplyType() {
		// TODO Auto-generated method stub
		return GET_DEVICE_REPLY;
	}
	
	public Device getDevice(){
		if (mode == DeviceType.POWERSWITCH)
			return powerSwitch;
		else if(mode == DeviceType.THERMOSTAT)
			return thermostat;
		else
			return device;
	}
	
	

}
